# Arcs
import pygame
import math

def distance (a, b):
    d = (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])
    return math.sqrt(d)

def pieslice (cx, cy, w, h, a1, a2):
    ell(cx, cy, w, h, a1, a2)
    xs = cx + a*math.cos(-a1)
    ys = cy + b*math.sin(-a1)
    xe = cx + a*math.cos(-a2)
    ye = cy + b*math.sin(-a2)
    pygame.draw.line(screen, (255, 0, 0), (xs, ys), (cx, cy), 4)
    pygame.draw.line(screen, (255, 0, 0), (xe, ye), (cx, cy), 4)

def chord (cx, cy, w, h, a1, a2):
    pygame.draw.arc(screen, (255, 0, 0), (cx-w/2, cy-h/2, w, h), a1, a2, 4)
#    ell(cx, cy, w, h, a1, a2)
    xs = cx + a*math.cos(-a1)
    ys = cy + b*math.sin(-a1)
    xe = cx + a*math.cos(-a2)
    ye = cy + b*math.sin(-a2)
    pygame.draw.line(screen, (255, 0, 0), (xs, ys), (xe, ye), 4)

def ell (cx, cy, w, h, a1, a2):
    t = a1
    x0 = cx + w/2* math.cos(-t)
    y0 = cy + h/2* math.sin(-t)
    while t < a2:
#    for t in range(a1, a2):
        print(x0, y0)
        t = t + 0.01
        x1 = cx + w/2 * math.cos(-t)
        y1 = cy + h/2 * math.sin(-t)
        pygame.draw.line(screen, (100, 0, 0), (x0,y0), (x1,y1), 2)
        x0 = x1
        y0 = y1



width = 600
height = 600
screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
pygame.init()
FPS = 10
a1 = math.radians(-60)
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()

    screen.fill((255, 255, 255))
    xc = 250
    yc = 400
    a = 150
    b = 100
    a2 = math.radians(45)
    chord (250, 100, 300, 200, a1, a2)
    pieslice (250, 400, 300, 200, a1, a2)
    pygame.display.update()
